<?php

namespace App\Http\Controllers\Admin;

use App\UserServices;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Html\Builder;

class UserServicesController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth_admin', 'can:Access Admin Panel']);
        $this->middleware('intend_url')->only(['index', 'read']);
        $this->middleware('can:Create User Services')->only(['createForm', 'create']);
        $this->middleware('can:Read User Services')->only(['index', 'read']);
        $this->middleware('can:Update User Services')->only(['updateForm', 'update']);
        $this->middleware(['can:Delete User Services'])->only('delete');
    }

    public function index(Builder $builder)
    {
        if (request()->ajax()) {
            $user_services = UserServices::query();
            $datatable = datatables($user_services)
                ->editColumn('actions', function ($user_services) {
                    return view('admin.user_services.datatable.actions', compact('user_services'));
                })
                ->rawColumns(['actions']);

            return $datatable->toJson();
        }

        $html = $builder->columns([
            ['title' => 'Full Name', 'data' => 'fullname'],
            ['title' => 'Already a member?', 'data' => 'alreadymember'],
            ['title' => 'Membership No', 'data' => 'membershipno'],
            ['title' => 'Name Of The Association', 'data' => 'association'],
            ['title' => 'Name Of The Company', 'data' => 'company'],
            ['title' => 'Company Address', 'data' => 'companyaddress'],
            ['title' => 'Contact No.', 'data' => 'contactno'],
            ['title' => 'Email Id', 'data' => 'email'],
            ['title' => 'Type Of Operation', 'data' => 'operationtype'],
            ['title' => 'Select Product', 'data' => 'product'],
            ['title' => 'Business Details', 'data' => 'businessdetails'],
            ['title' => 'Area Of Operation', 'data' => 'operationarea'],
            ['title' => 'CIN No.', 'data' => 'cinno'],
            ['title' => 'GST No.', 'data' => 'gstno'],
            ['title' => 'MSME Registration No.', 'data' => 'msmeno'],
            ['title' => 'KVSC Registration No.', 'data' => 'kvscno'],
            ['title' => 'Any Other Registration', 'data' => 'otherreg'],
            ['title' => 'Type Of Company', 'data' => 'companytype'],
            ['title' => 'Annual Turn Over', 'data' => 'turnover'],
            ['title' => '', 'data' => 'actions', 'searchable' => false, 'orderable' => false],
        ]);
        $html->setTableAttribute('id', 'user_services_datatable');

        return view('admin.user_services.index', compact('html'));
    }

    public function createForm()
    {
        return view('admin.user_services.create');
    }

    public function create()
    {
        $this->validate(request(), [
            "fullname" => "required",
            "membershipno" => "required",
            "association" => "required",
            "company" => "required",
            "companyaddress" => "required",
            "contactno" => "required",
            "email" => "required",
            "operationtype" => "required|in:Manufaturer,Trader,Service,Artist",
            "product" => "required|in:Plastic,Moulds,Software,Transportation",
            "businessdetails" => "required",
            "operationarea" => "required",
            "cinno" => "required",
            "gstno" => "required",
            "msmeno" => "required",
            "kvscno" => "required",
            "otherreg" => "required",
            "turnover" => "required",
        ]);

        $user_services = UserServices::create(request()->all());

        activity('Created User Services: ' . $user_services->fullname, request()->all(), $user_services);
        flash(['success', 'User Services created!']);

        if (request()->input('_submit') == 'redirect') {
            return response()->json(['redirect' => session()->pull('url.intended', route('admin.user_services'))]);
        }
        else {
            return response()->json(['reload_page' => true]);
        }
    }

    public function read(UserServices $user_services)
    {
        return view('admin.user_services.read', compact('user_services'));
    }

    public function updateForm(UserServices $user_services)
    {
        return view('admin.user_services.update', compact('user_services'));
    }

    public function update(UserServices $user_services)
    {
        $this->validate(request(), [
            "fullname" => "required",
            "membershipno" => "required",
            "association" => "required",
            "company" => "required",
            "companyaddress" => "required",
            "contactno" => "required",
            "email" => "required",
            "operationtype" => "required|in:Manufaturer,Trader,Service,Artist",
            "product" => "required|in:Plastic,Moulds,Software,Transportation",
            "businessdetails" => "required",
            "operationarea" => "required",
            "cinno" => "required",
            "gstno" => "required",
            "msmeno" => "required",
            "kvscno" => "required",
            "otherreg" => "required",
            "turnover" => "required",
        ]);

        $user_services->update(request()->all());

        activity('Updated User Services: ' . $user_services->fullname, request()->all(), $user_services);
        flash(['success', 'User Services updated!']);

        if (request()->input('_submit') == 'redirect') {
            return response()->json(['redirect' => session()->pull('url.intended', route('admin.user_services'))]);
        }
        else {
            return response()->json(['reload_page' => true]);
        }
    }

    public function delete(UserServices $user_services)
    {
        $user_services->delete();

        activity('Deleted User Services: ' . $user_services->fullname, $user_services->toArray());
        $flash = ['success', 'User Services deleted!'];

        if (request()->input('_submit') == 'reload_datatables') {
            return response()->json([
                'flash' => $flash,
                'reload_datatables' => true,
            ]);
        }
        else {
            flash($flash);

            return redirect()->route('admin.user_services');
        }
    }
}