<?php

namespace App\Http\Controllers\Auth;

use GuzzleHttp\Middleware;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class MemberLoginController extends Controller
{
    public function __construct()
    {
        //$this->middleware('guest:member');
    }
    
    public function showLoginForm()
    {
        return view('login');
    }
    public function login(Request $request)
    {   
        //validate the form data
        $this->validate($request,[
            'email' => 'required|email',
            'password' => 'required|min:6',
        ]);
        //Attempt to log the user in 
        // Auth::guard('member')->attempt(['email' => $request->email, 'password' => $request->password]);
        if(Auth::guard('member')->attempt(['email' => $request->email, 'password' => $request->password])){
            //if successful, the redirect to their intended location
            
            return redirect()->intended('listservices');
        }
        //if unsuccessful, the redirect back to the login with the form detail
        return redirect()->back()->withInput($request->only('email'));
    }
    public function memberlogout(Request $request) {
        Auth::guard('member')->logout();
        return redirect('/login');
      }

}