<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Member;

class Members extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function __construct()
    {
        $this->middleware(['auth:member']);
    }
    public function index()
    {
        $listservices = DB::table('user_services')->paginate(1);
        // return view('admin.user_services.read', compact('user_services'));
        
        return view('listservices', ['services' => $listservices]);
    }

    public function myaccount()
    {
//         $user = Auth::guard('member')->user();
//         echo "<pre>";
// print_r($user);
// $id = Auth::guard('member')->user()->membershipno;
//          print_r($id);
// exit;
        return view('myaccount');
    }

    public function viewprofile()
    {
        return view('viewprofile');
    }

    public function updateprofile()
    {
        $companydetails = DB::table('user_services')
                ->where('id', '=', Auth::guard('member')->user()->id)
                ->get();
        // echo "<pre>";
        // print_r($companydetails); exit;
        return view('updateprofile', ['companydetails' => $companydetails]);
    }

    public function updateservice()
    {
        dd(request()->all());
        exit;
        $member_id = Auth::guard('member')->user()->id;
        // Update Company Details
        DB::table('user_services')
              ->where('id', $member_id)
              ->update(['company' => request()->input('companyname'),
              'contactno' => request()->input('contact'),
              'email' => request()->input('email'),
              'businessdetails' => request()->input('businessactivities'),
              'companytype' => request()->input('companytype'),
              'turnover' => request()->input('annual'),
              'client1' => request()->input('majorclient1'),
              'client2' => request()->input('majorclient2'),
              'client3' => request()->input('majorclient3')]);

        // Add Services
        DB::table('services')->where('user_services_id', '=', $member_id)->delete();
        foreach (request()->input('servicename') as $serno=>$servicename) {
            DB::table('services')->insert([
                'user_services_id' => $member_id,
                'name' => $servicename,
                'description' => request()->input('servicedesc')[$serno],
                'image' => request()->input('serviceimage')[$serno],
            ]);
        }
        // Add Skills
        DB::table('skills')->where('user_services_id', '=', $member_id)->delete();
        foreach (request()->input('profskill') as $skillno=>$skillname) {
            DB::table('skills')->insert([
                'user_services_id' => $member_id,
                'name' => $skillname,
                'star' => request()->input('rating')[$skillno],
            ]);
        }
        // Add Experience
        DB::table('experience')->where('user_services_id', '=', $member_id)->delete();
        foreach (request()->input('jobtitle') as $expno=>$expetitle) {
            DB::table('experience')->insert([
                'user_services_id' => $member_id,
                'title' => $expetitle,
                'companyname' => request()->input('companyname')[$expno],
                'startdate' => request()->input('startdate')[$expno],
                'enddate' => request()->input('enddate')[$expno],
                'description' => request()->input('workexp')[$expno],
            ]);
        }

        // Add Education
        DB::table('education')->where('user_services_id', '=', $member_id)->delete();
        foreach (request()->input('unicountry') as $eduno=>$educontry) {
            DB::table('education')->insert([
                'user_services_id' => $member_id,
                'country' => $educontry,
                'college' => request()->input('uniname')[$eduno],
                'degree' => request()->input('degreename')[$eduno],
                'startdate' => request()->input('startyear')[$eduno],
                'enddate' => request()->input('endyear')[$eduno],
            ]);
        }

         // Add Qualification
         DB::table('qualification')->where('user_services_id', '=', $member_id)->delete();
         foreach (request()->input('procertificate') as $quano=>$quacerti) {
            DB::table('qualification')->insert([
                'user_services_id' => $member_id,
                'certificates' => $quacerti,
                'organisations' => request()->input('conforg')[$quano],
                'description' => request()->input('qualific')[$quano],
            ]);
        }
        return redirect()->route('updateprofile');
        // return view('updateservice');
    }
}
