<?php

return [

    // paths & files used for generating
    'paths' => [
        'stubs' => 'vendor/kjjdion/laravel-admin-panel/resources/stubs/crud/UserServices',
        'controller' => 'app/Http/Controllers/Admin',
        'model' => 'app',
        'migrations' => 'database/migrations',
        'views' => 'resources/views/admin',
        'menu' => 'resources/views/vendor/lap/layouts/menu.blade.php',
        'routes' => 'routes/web.php',
    ],

    // menu icon (fontawesome class)
    'icon' => 'fa-link',

    // model attributes
    'attributes' => [

        'fullname' => [
            'primary' => true,
            'migrations' => [
                'string:fullname',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Full Name',
                'data' => 'fullname',
            ],
            'input' => [
                'type' => 'text',
            ],
        ], 

        'alreadymember' => [
            'migrations' => [
                'string:alreadymember|nullable',
            ],
            'datatable' => [
                'title' => 'Already a member?',
                'data' => 'alreadymember',
            ],
            'input' => [
                'type' => 'radio',
                'options' => ['Yes', 'No'],
            ],
        ],

        'membershipno' => [
            'migrations' => [
                'string:membershipno',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Membership No',
                'data' => 'membershipno',
            ],
            'input' => [
                'type' => 'text',
            ],
        ], 

        'association' => [
            'migrations' => [
                'string:association',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Name Of The Association',
                'data' => 'association',
            ],
            'input' => [
                'type' => 'text',
            ],
        ], 

        'company' => [
            'migrations' => [
                'string:company',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Name Of The Company',
                'data' => 'company',
            ],
            'input' => [
                'type' => 'text',
            ],
        ], 

        'companyaddress' => [
            'migrations' => [
                'string:companyaddress',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Company Address',
                'data' => 'companyaddress',
            ],
            'input' => [
                'type' => 'text',
            ],
        ], 

        'contactno' => [
            'migrations' => [
                'string:contactno',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Contact No.',
                'data' => 'contactno',
            ],
            'input' => [
                'type' => 'text',
            ],
        ], 

        'email' => [
            'migrations' => [
                'string:email',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Email Id',
                'data' => 'email',
            ],
            'input' => [
                'type' => 'text',
            ],
        ], 

        'operationtype' => [
            'migrations' => [
                'string:operationtype',
            ],
            'validations' => [
                'create' => 'required|in:Manufaturer,Trader,Service,Artist',
                'update' => 'required|in:Manufaturer,Trader,Service,Artist',
            ],
            'datatable' => [
                'title' => 'Type Of Operation',
                'data' => 'operationtype',
            ],
            'input' => [
                'type' => 'select',
                'options' => ['Manufaturer', 'Trader', 'Service', 'Artist'],
            ],
        ], 

        'product' => [
            'migrations' => [
                'string:product',
            ],
            'validations' => [
                'create' => 'required|in:Plastic,Moulds,Software,Transportation',
                'update' => 'required|in:Plastic,Moulds,Software,Transportation',
            ],
            'datatable' => [
                'title' => 'Select Product',
                'data' => 'product',
            ],
            'input' => [
                'type' => 'select',
                'options' => ['Plastic', 'Moulds', 'Software', 'Transportation'],
            ],
        ], 

        'businessdetails' => [
            'migrations' => [
                'string:businessdetails',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Business Details',
                'data' => 'businessdetails',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],
        
        'operationarea' => [
            'migrations' => [
                'string:operationarea',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Area Of Operation',
                'data' => 'operationarea',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'cinno' => [
            'migrations' => [
                'string:cinno',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'CIN No.',
                'data' => 'cinno',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'gstno' => [
            'migrations' => [
                'string:gstno',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'GST No.',
                'data' => 'gstno',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'msmeno' => [
            'migrations' => [
                'string:msmeno',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'MSME Registration No.',
                'data' => 'msmeno',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'kvscno' => [
            'migrations' => [
                'string:kvscno',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'KVSC Registration No.',
                'data' => 'kvscno',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'otherreg' => [
            'migrations' => [
                'string:otherreg',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Any Other Registration',
                'data' => 'otherreg',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'companytype' => [
            'migrations' => [
                'string:companytype|nullable',
            ],
            'datatable' => [
                'title' => 'Type Of Company',
                'data' => 'companytype',
            ],
            'input' => [
                'type' => 'radio',
                'options' => ['Proprietary', 'LLP', 'Pvt. Ltd.', 'Limited'],
            ],
        ],

        'turnover' => [
            'migrations' => [
                'string:turnover',
            ],
            'validations' => [
                'create' => 'required',
                'update' => 'required',
            ],
            'datatable' => [
                'title' => 'Annual Turn Over',
                'data' => 'turnover',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'client1' => [
            'migrations' => [
                'string:client1',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'client2' => [
            'migrations' => [
                'string:client2',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'client3' => [
            'migrations' => [
                'string:client3',
            ],
            'input' => [
                'type' => 'text',
            ],
        ],

        'agreeterms' => [
            'migrations' => [
                'boolean:agreeterms|nullable',
            ],
            'input' => [
                'type' => 'checkbox',
                'value' => true,
                'label' => 'Agree Terms',
            ],
        ],


    ],

];