<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserServicesTable extends Migration
{
    public function up()
    {
        // create table
        Schema::create('user_services', function (Blueprint $table) {
            $table->increments('id');
            $table->string('fullname');
            $table->string('alreadymember')->nullable();
            $table->string('membershipno');
            $table->string('association');
            $table->string('company');
            $table->string('companyaddress');
            $table->string('contactno');
            $table->string('email');
            $table->string('operationtype');
            $table->string('product');
            $table->string('businessdetails');
            $table->string('operationarea');
            $table->string('cinno');
            $table->string('gstno');
            $table->string('msmeno');
            $table->string('kvscno');
            $table->string('otherreg');
            $table->string('companytype')->nullable();
            $table->string('turnover');
            $table->string('client1');
            $table->string('client2');
            $table->string('client3');
            $table->boolean('agreeterms')->nullable();
            $table->timestamps();
        });

        // add permissions
        app(config('lap.models.permission'))->createGroup('User Services', ['Create User Services', 'Read User Services', 'Update User Services', 'Delete User Services']);
    }

    public function down()
    {
        // drop table
        Schema::dropIfExists('user_services');

        // delete permissions
        app(config('lap.models.permission'))->where('group', 'User Services')->delete();
    }
}