@extends('lap::layouts.auth')

@section('title', 'Create User Services')
@section('child-content')
    <h2>@yield('title')</h2>

    <form method="POST" action="{{ route('admin.user_services.create') }}" novalidate data-ajax-form>
        @csrf

        <div class="list-group">
            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="fullname" class="col-md-2 col-form-label">Fullname</label>
                    <div class="col-md-8">
                        <input type="text" name="fullname" id="fullname" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="alreadymember" class="col-md-2 col-form-label">Alreadymember</label>
                    <div class="col-md-8">
                        <div class="form-control-plaintext">
                            <input type="hidden" name="{attribute}">
                            @foreach(['Yes', 'No'] as $option)
                                <div class="custom-control custom-radio">
                                    <input type="radio" name="alreadymember" id="alreadymember_{{ $loop->index }}" class="custom-control-input" value="{{ $option }}">
                                    <label for="alreadymember_{{ $loop->index }}" class="custom-control-label">{{ $option }}</label>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="membershipno" class="col-md-2 col-form-label">Membershipno</label>
                    <div class="col-md-8">
                        <input type="text" name="membershipno" id="membershipno" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="association" class="col-md-2 col-form-label">Association</label>
                    <div class="col-md-8">
                        <input type="text" name="association" id="association" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="company" class="col-md-2 col-form-label">Company</label>
                    <div class="col-md-8">
                        <input type="text" name="company" id="company" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="companyaddress" class="col-md-2 col-form-label">Companyaddress</label>
                    <div class="col-md-8">
                        <input type="text" name="companyaddress" id="companyaddress" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="contactno" class="col-md-2 col-form-label">Contactno</label>
                    <div class="col-md-8">
                        <input type="text" name="contactno" id="contactno" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="email" class="col-md-2 col-form-label">Email</label>
                    <div class="col-md-8">
                        <input type="text" name="email" id="email" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="operationtype" class="col-md-2 col-form-label">Operationtype</label>
                    <div class="col-md-8">
                        <select name="operationtype" id="operationtype" class="form-control">
                            <option value=""></option>
                            @foreach(['Manufaturer', 'Trader', 'Service', 'Artist'] as $option)
                                <option value="{{ $option }}">{{ $option }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="product" class="col-md-2 col-form-label">Product</label>
                    <div class="col-md-8">
                        <select name="product" id="product" class="form-control">
                            <option value=""></option>
                            @foreach(['Plastic', 'Moulds', 'Software', 'Transportation'] as $option)
                                <option value="{{ $option }}">{{ $option }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="businessdetails" class="col-md-2 col-form-label">Businessdetails</label>
                    <div class="col-md-8">
                        <input type="text" name="businessdetails" id="businessdetails" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="operationarea" class="col-md-2 col-form-label">Operationarea</label>
                    <div class="col-md-8">
                        <input type="text" name="operationarea" id="operationarea" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="cinno" class="col-md-2 col-form-label">Cinno</label>
                    <div class="col-md-8">
                        <input type="text" name="cinno" id="cinno" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="gstno" class="col-md-2 col-form-label">Gstno</label>
                    <div class="col-md-8">
                        <input type="text" name="gstno" id="gstno" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="msmeno" class="col-md-2 col-form-label">Msmeno</label>
                    <div class="col-md-8">
                        <input type="text" name="msmeno" id="msmeno" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="kvscno" class="col-md-2 col-form-label">Kvscno</label>
                    <div class="col-md-8">
                        <input type="text" name="kvscno" id="kvscno" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="otherreg" class="col-md-2 col-form-label">Otherreg</label>
                    <div class="col-md-8">
                        <input type="text" name="otherreg" id="otherreg" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="companytype" class="col-md-2 col-form-label">Companytype</label>
                    <div class="col-md-8">
                        <div class="form-control-plaintext">
                            <input type="hidden" name="{attribute}">
                            @foreach(['Proprietary', 'LLP', 'Pvt. Ltd.', 'Limited'] as $option)
                                <div class="custom-control custom-radio">
                                    <input type="radio" name="companytype" id="companytype_{{ $loop->index }}" class="custom-control-input" value="{{ $option }}">
                                    <label for="companytype_{{ $loop->index }}" class="custom-control-label">{{ $option }}</label>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="turnover" class="col-md-2 col-form-label">Turnover</label>
                    <div class="col-md-8">
                        <input type="text" name="turnover" id="turnover" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="client1" class="col-md-2 col-form-label">Client1</label>
                    <div class="col-md-8">
                        <input type="text" name="client1" id="client1" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="client2" class="col-md-2 col-form-label">Client2</label>
                    <div class="col-md-8">
                        <input type="text" name="client2" id="client2" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="client3" class="col-md-2 col-form-label">Client3</label>
                    <div class="col-md-8">
                        <input type="text" name="client3" id="client3" class="form-control">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="agreeterms" class="col-md-2 col-form-label">Agreeterms</label>
                    <div class="col-md-8">
                        <div class="form-control-plaintext">
                            <input type="hidden" name="{attribute}">
                            @foreach([true] as $option)
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" name="agreeterms" id="agreeterms_{{ $loop->index }}" class="custom-control-input" value="{{ $option }}">
                                    <label for="agreeterms_{{ $loop->index }}" class="custom-control-label">Agree Terms</label>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <div class="list-group-item bg-light text-left text-md-right pb-1">
                <button type="submit" name="_submit" class="btn btn-primary mb-2" value="reload_page">Save</button>
                <button type="submit" name="_submit" class="btn btn-primary mb-2" value="redirect">Save &amp; Go Back</button>
            </div>
        </div>
    </form>
@endsection