<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link href="https://fonts.googleapis.com/css?family=Nunito:regular,bold" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('lap/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('lap/css/fontawesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('lap/css/datatables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('lap/css/easymde.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('lap/css/lap.css')); ?>">

    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(config('app.name')); ?></title>
</head>
<body class="<?php echo $__env->yieldContent('body-class'); ?>"<?php echo session('flash') ? ' data-flash-class="'.session('flash.0').'" data-flash-message="'.session('flash.1').'"' : ''; ?>>

<?php echo $__env->yieldContent('parent-content'); ?>

<script src="<?php echo e(asset('lap/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('lap/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('lap/js/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('lap/js/easymde.min.js')); ?>"></script>
<script src="<?php echo e(asset('lap/js/lap.js')); ?>"></script>
<?php echo $__env->yieldPushContent('scripts'); ?>

</body>
</html>