<?php $__env->startSection('title', 'Update Role'); ?>
<?php $__env->startSection('child-content'); ?>
    <h2><?php echo $__env->yieldContent('title'); ?></h2>

    <form method="POST" action="<?php echo e(route('admin.roles.update', $role->id)); ?>" novalidate data-ajax-form>
        <?php echo csrf_field(); ?>
        <?php echo method_field('PATCH'); ?>

        <div class="list-group">
            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label for="name" class="col-md-2 col-form-label">Name</label>
                    <div class="col-md-8">
                        <input type="text" name="name" id="name" class="form-control" value="<?php echo e($role->name); ?>">
                    </div>
                </div>
            </div>

            <div class="list-group-item">
                <div class="form-group row mb-0">
                    <label class="col-md-2 col-form-label">Permissions</label>
                    <div class="col-md-8">
                        <div class="form-control-plaintext">
                            <?php if($role->admin): ?>
                                This role always has all permissions.
                            <?php else: ?>
                                <?php $__currentLoopData = $group_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <b class="d-block<?php echo e(!$loop->first ? ' mt-3' : ''); ?>"><?php echo e($group); ?></b>
                                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="custom-control custom-control-inline custom-checkbox">
                                            <input type="checkbox" name="permissions[]" id="permission_<?php echo e($permission->id); ?>" class="custom-control-input" value="<?php echo e($permission->id); ?>"
                                                    <?php echo e($role->permissions->contains('id', $permission->id) ? ' checked' : ''); ?>>
                                            <label for="permission_<?php echo e($permission->id); ?>" class="custom-control-label"><?php echo e($permission->name); ?></label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="list-group-item bg-light text-left text-md-right pb-1">
                <button type="submit" name="_submit" class="btn btn-primary mb-2" value="reload_page">Save</button>
                <button type="submit" name="_submit" class="btn btn-primary mb-2" value="redirect">Save &amp; Go Back</button>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('lap::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>