<?php $__env->startSection('title', 'Role'); ?>
<?php $__env->startSection('child-content'); ?>
    <div class="row mb-3">
        <div class="col-md">
            <h2 class="mb-0"><?php echo $__env->yieldContent('title'); ?></h2>
        </div>
        <div class="col-md-auto mt-2 mt-md-0">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Update Roles')): ?>
                <a href="<?php echo e(route('admin.roles.update', $role->id)); ?>" class="btn btn-primary">Update</a>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Delete Roles')): ?>
                <form method="POST" action="<?php echo e(route('admin.roles.delete', $role->id)); ?>" class="d-inline-block">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-primary" data-confirm<?php echo e($role->admin ? ' disabled' : ''); ?>>Delete</button>
                </form>
            <?php endif; ?>
        </div>
    </div>

    <div class="list-group">
        <div class="list-group-item">
            <div class="row">
                <div class="col-md-2">ID</div>
                <div class="col-md-8"><?php echo e($role->id); ?></div>
            </div>
        </div>

        <div class="list-group-item">
            <div class="row">
                <div class="col-md-2">Name</div>
                <div class="col-md-8"><?php echo e($role->name); ?></div>
            </div>
        </div>

        <div class="list-group-item">
            <div class="row">
                <div class="col-md-2">Permissions</div>
                <div class="col-md-8">
                    <?php if($role->admin): ?>
                        This role always has all permissions.
                    <?php else: ?>
                        <?php echo e($role->permissions->sortBy('id')->implode('name', ', ')); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="list-group-item">
            <div class="row">
                <div class="col-md-2">Created At</div>
                <div class="col-md-8"><?php echo e($role->created_at); ?></div>
            </div>
        </div>

        <div class="list-group-item">
            <div class="row">
                <div class="col-md-2">Updated At</div>
                <div class="col-md-8"><?php echo e($role->updated_at); ?></div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('lap::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>